import 'dart:convert';
import 'dart:developer';
import 'dart:io';
import 'package:flutter/foundation.dart';
import 'package:nexthour/models/gst_model.dart';
import '/common/apipath.dart';
import '/common/global.dart';
import 'package:http/http.dart' as http;

class GstProvider with ChangeNotifier {
  AddGst? gstModel;

  Future<AddGst?> fetchGstDetails() async {
    try {
      final response = await http.get(Uri.parse(APIData.gst), headers: {
        "Content-Type": "application/x-www-form-urlencoded",
        HttpHeaders.authorizationHeader: "Bearer $authToken"
      });
      print('Payment Keys API :-> ${APIData.gst}');
      log('Gst :-> ${response.body}');
      print(response.statusCode);
      if (response.statusCode == 200) {
        gstModel = AddGst.fromJson(json.decode(response.body));
      } else {
        throw "Can't get payment keys";
      }
      notifyListeners();
      return gstModel;
    } catch (error) {
      print('Payment Keys API :-> ${APIData.gst}');
      throw error;
    }
  }
}
